import numpy as np

from metaworld.policies.action import Action
from metaworld.policies.policy import Policy, assert_fully_parsed, move


class SawyerPlateSlideBackV2Policy(Policy):

    @staticmethod
    @assert_fully_parsed
    def _parse_obs(obs):
        return {
            'hand_pos': obs[:3],
            'unused_1': obs[3],
            'puck_pos': obs[4:7],
            'unused_2': obs[7:-3],
            'goal_pos': obs[-3:],
        }

    def get_action(self, obs):
        o_d = self._parse_obs(obs)

        action = Action({
            'delta_pos': np.arange(3),
            'grab_effort': 3
        })

        action['delta_pos'] = move(o_d['hand_pos'], to_xyz=self._desired_pos(o_d), p=10.)
        action['grab_effort'] = -1.

        return action.array

    @staticmethod
    def _desired_pos(o_d):
        pos_curr = o_d['hand_pos']
        pos_puck = o_d['puck_pos'] + np.array([.0, -.065, .025])

        # if np.linalg.norm(pos_curr[:2] - pos_puck[:2]) > 0.01:
        if np.linalg.norm(pos_curr[:2] - pos_puck[:2]) > 0.01:
            print('mode 1', pos_puck + np.array([.0, .0, .1]) )
            return pos_puck + np.array([.0, .0, .1])
        elif abs(pos_curr[2] - pos_puck[2]) > 0.04:
            print('mode 2', pos_puck )
            return pos_puck
        elif pos_curr[1] > .7:
            print('mode 3', pos_curr + np.array([.0, -.1, .0]) )
            return pos_curr + np.array([.0, -.1, .0])
        elif pos_curr[1] > .6:
            print('mode 4', np.array([.15, .55, pos_curr[2]]) )
            return np.array([.15, .55, pos_curr[2]])
        else:
            print('mode 5', o_d['goal_pos'] )
            # return np.array([pos_curr[0] - .1, .55, pos_curr[2]])
            return o_d['goal_pos'] + np.array([.0, -.05, .0]) # modification: use goal pos and change the tolerance
